# GeekOS Documentation

This directory contains documentation for students working on GeekOS projects.

## Core Documentation

| File | Description |
|------|-------------|
| `geekos-setup.md` | Development environment setup (Docker, Linux, macOS) |
| `geekos-architecture.md` | System architecture, boot process, key subsystems |
| `os-concepts.md` | OS concepts with links to OSTEP textbook chapters |
| `project-guide.md` | Overview of all projects (P1-P5) |
| `advanced-internals.md` | Low-level x86 details, memory maps, context switching |
| `running-geekos.md` | How to build and run GeekOS in QEMU |

## Concurrency Documentation (Progressive Disclosure)

Concurrency concepts are introduced progressively across projects:

| File | Description |
|------|-------------|
| `concurrency.md` | **Index** - links to topics in project-specific docs |
| `p1/concurrency.md` | P1 questions - fill in your understanding as you learn |

**How it works:**
1. Work through questions in `p1/concurrency.md` before/during implementation
2. Fill in "Your Understanding" sections with your answers
3. After P1 deadline, you'll receive a supplement to compare answers

## Instructor-Only Materials

Materials in `instructor/` (answer keys, supplements, templates) are NOT distributed to students until after project deadlines.
