/*
 * Copyright (c) 1996,2013,2014 Jeffrey K. Hollingsworth <hollings@cs.umd.edu>
 *
 * All rights reserved.
 *
 * This code may not be resdistributed without the permission of the copyright holders.
 * Any student solutions using any of this code base constitute derviced work and may
 * not be redistributed in any form.  This includes (but is not limited to) posting on
 * public forums or web sites, providing copies to (past, present, or future) students
 * enrolled in similar operating systems courses the University of Maryland's CMSC412 course.
 */

/**********************************************************************

	    Project 2: Multiprogramming 


  By:
      Jeff Hollingsworth
  e-mail:
      hollings@cs.umd.edu

  File:        proc2.c
  Created on:  3/6/1996
  Contents:    User Processes to be run concurrently
	  1.    Init() : Initial process, creates other ones & terminates
	  2..4  Long() , Ping() , and Pong() are three examplar processes
	  that are to be run concurently.  Long() is a CPU intensive
          job, while Ping() and Pong() bounce back between one another.
	  5.    Wait() : busy wait for a key to be pressed

  Simon Hawkin <cema@cs.umd.edu> 03/16/1998
      - Added progress monitoring output in Long().
  Jeff Hollingsworth <hollings@cs.umd.edu> 2/19/02
      - Re-written for the new project
  David Hovemeyer <daveho@cs.umd.edu> 2/27/04
      - Update for GeekOS 0.2.0


  [2] An enclosed test ("proc2.c", or "encl2.c").

**********************************************************************/

#include <conio.h>
#include <process.h>
#include <sched.h>
#include <sema.h>
#include <string.h>

#if !defined (NULL)
#define NULL 0
#endif

int main(int argc, char **argv) {
    int policy = -1;
    int start;
    int elapsed;
    int scr_sem;                /* sid of screen semaphore */
    int id1, id2;               /* ID of child process */

    if(argc == 2) {
        if(!strcmp(argv[1], "rr")) {
            policy = 0;
        } else if(!strcmp(argv[1], "mys")) {
            policy = 1;
        } else {
            Print("usage: %s [rr|mys]\n", argv[0]);
            Exit(1);
        }
        Set_Scheduling_Policy(policy, 20);
    } else {
        Print("usage: %s [rr|mys]\n", argv[0]);
        Exit(1);
    }

    start = Get_Time_Of_Day();
    scr_sem = Open_Semaphore("screen", 1);

    P(scr_sem);
    Print("************* Start Workload Generator *********\n");
    V(scr_sem);

    id1 = Spawn_Program("/c/long.exe", "/c/long.exe", 0);
    P(scr_sem);
    Print("Process Long has been created with ID = %d\n", id1);
    V(scr_sem);


    id2 = Spawn_Program("/c/long.exe", "/c/long.exe", 0);

    P(scr_sem);
    Print("Process Long #1 has been created with ID = %d\n", id2);
    V(scr_sem);

#ifdef notdef
    id2 = Spawn_Program("/c/ping.exe", "/c/ping.exe", 0);

    P(scr_sem);
    Print("Process Ping has been created with ID = %d\n", id2);
    V(scr_sem);

    id3 = Spawn_Program("/c/pong.exe", "/c/pong.exe", 0);
    P(scr_sem);
    Print("Process Pong has been created with ID = %d\n", id3);
    V(scr_sem);
#endif

    Wait(id1);
    Wait(id2);
    // Wait(id3);

    elapsed = Get_Time_Of_Day() - start;
    Print("\nTests Completed at %d\n", elapsed);
    return 0;
}
