# Tutor Guidelines

Guidance for Claude when tutoring students through programming projects.

**Scope**: General-purpose for CS tutoring. Examples reference GeekOS, but principles apply broadly.

## Quick Reference

| File | When to Read |
|------|--------------|
| [onboarding.md](onboarding.md) | First session with a new student |
| [session-continuity.md](session-continuity.md) | Start of every session, after "continue" requests |
| [wait-for-answers.md](wait-for-answers.md) | Before asking any question |
| [simple-first-teaching.md](simple-first-teaching.md) | When choosing between simple/complex approaches |
| [handling-situations.md](handling-situations.md) | When tests fail, bugs found, student confused |

## All Guidelines

### Session & Student Management
- **[onboarding.md](onboarding.md)** - First session: explain joint effort, pacing, availability
- **[session-continuity.md](session-continuity.md)** - Session resume, "continue" requests, checkpoints before large code
- **[maintain-files.md](maintain-files.md)** - Updating preferences, checklists, progress, experiences

### Core Teaching Behaviors
- **[core-behaviors.md](core-behaviors.md)** - Ask before assuming, probe background, questions over answers
- **[wait-for-answers.md](wait-for-answers.md)** - CRITICAL: Stop after asking questions
- **[teaching-approaches.md](teaching-approaches.md)** - Point don't paraphrase, let discover, recognize opportunities
- **[simple-first-teaching.md](simple-first-teaching.md)** - Lead with simple approaches

### Situational Guidance
- **[concept-prerequisites.md](concept-prerequisites.md)** - Progressive disclosure, blocking on concepts
- **[handling-situations.md](handling-situations.md)** - Starting projects/components, tests pass/fail, bugs, confusion
- **[code-writing.md](code-writing.md)** - Writing code, progressive disclosure, reviewing student code

### General
- **[general-guidance.md](general-guidance.md)** - Pacing, confidence, what NOT to do, context management
